/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.cim.provider.pi;

import com.ibm.hsc.cim.provider.rs6k.CimomWrapper;
import com.ibm.hsc.common.exceptions.PIHscServerException;
import com.ibm.hsc.common.util.HSCLogUtils;
import com.ibm.hsc.common.util.Trace;
import com.ibm.hsc.fsp.FSPCmdMgr;
import com.ibm.hsc.fsp.cmdhelpers.FspCmdHelper;
import com.ibm.hsc.fsp.cmdhelpers.FspHmcInfoData;
import com.ibm.hsc.fsp.cmdhelpers.FspHmcInformation;
import com.ibm.hsc.fsp.cmdhelpers.FspLockRecord;
import com.ibm.hsc.fsp.lockmgr.FspLockMgr;
import com.ibm.hsc.objmgr.cec.OmCecHscInfoUpdater;
import com.ibm.hsc.objmgr.cec.OmCecMgr;
import java.util.Vector;
import org.snia.wbem.cim.CIMClass;
import org.snia.wbem.cim.CIMDataType;
import org.snia.wbem.cim.CIMException;
import org.snia.wbem.cim.CIMObjectPath;
import org.snia.wbem.cim.CIMProperty;
import org.snia.wbem.cim.CIMValue;
import org.snia.wbem.cim.UnsignedInt16;
import org.snia.wbem.cim.UnsignedInt32;
import org.snia.wbem.cim.UnsignedInt8;
import org.snia.wbem.client.CIMOMHandle;
import org.snia.wbem.client.ProviderCIMOMHandle;
import org.snia.wbemcfg.GlobalConfig;

public class PIFSPLockFunctions {
    private static final String TRACE_MASK = "apcshscT";
    ProviderCIMOMHandle cimomHandle = null;
    OmCecMgr cecMgr = null;
    FspCmdHelper cmdHelper = null;
    String thisHmcMTMS = "";
    Vector hmcMTMSVec = new Vector();

    public PIFSPLockFunctions(OmCecMgr omCecMgr) {
        this.cecMgr = omCecMgr;
    }

    public CIMValue getHmcsWithLock(Vector vector) throws PIHscServerException {
        if (PIFSPLockFunctions.tracing(Trace.LEVEL)) {
            PIFSPLockFunctions.trace(TRACE_MASK, "-> PIFSPLockFunctions.getHmcsWithLock");
        }
        Vector vector2 = new Vector();
        Vector<String> vector3 = new Vector<String>();
        try {
            this.getFSPHMCInfo(vector2);
            FspLockMgr fspLockMgr = new FspLockMgr(this.cecMgr);
            if (this.hmcMTMSVec != null && this.hmcMTMSVec.size() > 0) {
                int n = this.hmcMTMSVec.size();
                for (int i = 0; i < n; ++i) {
                    String string = (String)this.hmcMTMSVec.get(i);
                    FspLockRecord[] fspLockRecordArray = fspLockMgr.getHmcLockStatus(string);
                    System.out.println("PIFSPLockFunctions.getHmcsWithLock: retrieving lockStatus for:" + string);
                    if (fspLockRecordArray != null && fspLockRecordArray.length > 0) {
                        if (!string.equals(this.thisHmcMTMS)) {
                            vector3.add(string);
                        } else {
                            System.out.println("PIFSPLockFunctions.getHmcsWithLock: this is curentHMC, should not be returned!");
                        }
                        System.out.println("PIFSPLockFunctions.getHmcsWithLock: total locks records: " + fspLockRecordArray.length);
                        continue;
                    }
                    System.out.println("PIFSPLockFunctions.getHmcsWithLock: no locks records found. ");
                }
            }
            System.out.println("PIFSPLockFunctions.getHmcsWithLock: return vector: " + vector3);
            vector.setSize(1);
            if (GlobalConfig.callMethodsWithValues) {
                vector.setElementAt(new CIMValue(vector3, new CIMDataType(29)), 0);
            } else {
                vector.setElementAt(new CIMProperty("HmcIds", new CIMValue(vector3, new CIMDataType(29))), 0);
            }
        }
        catch (PIHscServerException pIHscServerException) {
            if (PIFSPLockFunctions.tracing()) {
                PIFSPLockFunctions.trace(TRACE_MASK, "-> PIFSPLockFunctions.getHmcsWithLock: *ERROR*");
                pIHscServerException.printStackTrace();
            }
            if (!pIHscServerException.alreadyLogged()) {
                HSCLogUtils.serverLog(pIHscServerException, HSCLogUtils._CECClassLogInfo);
                pIHscServerException.setAlreadyLogged(true);
            }
            throw pIHscServerException;
        }
        if (PIFSPLockFunctions.tracing(Trace.LEVEL)) {
            PIFSPLockFunctions.trace(TRACE_MASK, "<- PIFSPLockFunctions.GetHmcsWithLock");
        }
        return new CIMValue((Object)new UnsignedInt8(0));
    }

    public CIMValue getFSPHMCInfo(Vector vector) throws PIHscServerException {
        FspHmcInformation[] fspHmcInformationArray;
        Object object;
        if (PIFSPLockFunctions.tracing(Trace.LEVEL)) {
            PIFSPLockFunctions.trace(TRACE_MASK, "-> PIFSPLockFunctions.getFSPHMCInfo");
        }
        String string = "";
        CIMObjectPath cIMObjectPath = new CIMObjectPath("IBMHSC_Console", "root/ibmhscS1_0");
        try {
            object = CimomWrapper.enumInstances((CIMOMHandle)this.cimomHandle, cIMObjectPath, false, new CIMClass("IBMHSC_Console"), false);
            fspHmcInformationArray = (FspHmcInformation[])((Vector)object).get(0);
            string = (String)fspHmcInformationArray.getProperty("Name").getValue().getValue();
        }
        catch (CIMException cIMException) {
            System.out.println("PIFSPLockFunctions->getFSPHMCInfo(): didn't get hmc VPD info.");
            PIFSPLockFunctions.trace(TRACE_MASK, "-> PIFSPLockFunctions.GetFSPHMCInfo *ERROR getting HMC VPD info.");
            cIMException.printStackTrace();
        }
        this.thisHmcMTMS = string;
        try {
            this.cmdHelper = this.cecMgr.getCmdHelper();
            object = new FspHmcInfoData();
            object = this.cmdHelper.getHmcInformation();
            fspHmcInformationArray = ((FspHmcInfoData)object).getFspHmcInfoList();
            Vector<String> vector2 = new Vector<String>();
            Vector<UnsignedInt32> vector3 = new Vector<UnsignedInt32>();
            Vector<UnsignedInt8> vector4 = new Vector<UnsignedInt8>();
            Vector<Boolean> vector5 = new Vector<Boolean>();
            for (int i = 0; i < fspHmcInformationArray.length; ++i) {
                String string2 = fspHmcInformationArray[i].getHmcId();
                if (string2.equals(string)) {
                    vector5.addElement(new Boolean(true));
                    System.out.println("\n\nFound Match HMCVPD:" + string2);
                } else {
                    vector5.addElement(new Boolean(false));
                }
                vector2.addElement(string2);
                vector3.addElement(fspHmcInformationArray[i].getToolType());
                vector4.addElement(fspHmcInformationArray[i].getHmcConnectionStatus());
            }
            this.hmcMTMSVec = vector2;
            vector.setSize(5);
            if (GlobalConfig.callMethodsWithValues) {
                vector.setElementAt(new CIMValue((Object)new UnsignedInt8((short)fspHmcInformationArray.length), new CIMDataType(1)), 0);
                vector.setElementAt(new CIMValue(vector2, new CIMDataType(29)), 1);
                vector.setElementAt(new CIMValue(vector3, new CIMDataType(25)), 2);
                vector.setElementAt(new CIMValue(vector4, new CIMDataType(21)), 3);
                vector.setElementAt(new CIMValue(vector5, new CIMDataType(30)), 4);
            } else {
                vector.setElementAt(new CIMProperty("HmcCount", new CIMValue((Object)new UnsignedInt8((short)fspHmcInformationArray.length), new CIMDataType(1))), 0);
                vector.setElementAt(new CIMProperty("HmcIds", new CIMValue(vector2, new CIMDataType(29))), 1);
                vector.setElementAt(new CIMProperty("ToolTypes", new CIMValue(vector3, new CIMDataType(25))), 2);
                vector.setElementAt(new CIMProperty("ConnectionStatusVals", new CIMValue(vector4, new CIMDataType(21))), 3);
                vector.setElementAt(new CIMProperty("CurrHmcBooleans", new CIMValue(vector5, new CIMDataType(30))), 4);
            }
        }
        catch (PIHscServerException pIHscServerException) {
            if (PIFSPLockFunctions.tracing()) {
                PIFSPLockFunctions.trace(TRACE_MASK, "-> PIFSPLockFunctions.GetFSPHMCInfo: *ERROR*");
                pIHscServerException.printStackTrace();
            }
            if (!pIHscServerException.alreadyLogged()) {
                HSCLogUtils.serverLog(pIHscServerException, HSCLogUtils._CECClassLogInfo);
                pIHscServerException.setAlreadyLogged(true);
            }
            throw pIHscServerException;
        }
        if (PIFSPLockFunctions.tracing(Trace.LEVEL)) {
            PIFSPLockFunctions.trace(TRACE_MASK, "<- PIFSPLockFunctions.GetFSPHMCInfo");
        }
        return new CIMValue((Object)new UnsignedInt8(0));
    }

    public CIMValue disconnectHMC(Vector vector) throws PIHscServerException {
        if (PIFSPLockFunctions.tracing(Trace.LEVEL)) {
            PIFSPLockFunctions.trace(TRACE_MASK, "-> PIFSPLockFunctions.disconnectHMC");
        }
        CIMValue cIMValue = null;
        cIMValue = GlobalConfig.callMethodsWithValues ? (CIMValue)vector.elementAt(0) : ((CIMProperty)vector.elementAt(0)).getValue();
        String string = (String)cIMValue.getValue();
        FspLockMgr fspLockMgr = new FspLockMgr(this.cecMgr);
        try {
            fspLockMgr.forceUnlock(string);
        }
        catch (PIHscServerException pIHscServerException) {
            if (PIFSPLockFunctions.tracing()) {
                PIFSPLockFunctions.trace(TRACE_MASK, "-> PIFSPLockFunctions.disconnectHMC: *ERROR*");
                pIHscServerException.printStackTrace();
            }
            if (!pIHscServerException.alreadyLogged()) {
                HSCLogUtils.serverLog(pIHscServerException, HSCLogUtils._CECClassLogInfo);
                pIHscServerException.setAlreadyLogged(true);
            }
            throw pIHscServerException;
        }
        if (PIFSPLockFunctions.tracing(Trace.LEVEL)) {
            PIFSPLockFunctions.trace(TRACE_MASK, "<- PIFSPLockFunctions.disconnectHMC");
        }
        return new CIMValue((Object)new UnsignedInt8(0));
    }

    public String getPHYPHmcInfo(UnsignedInt16 unsignedInt16) throws PIHscServerException {
        if (PIFSPLockFunctions.tracing(Trace.LEVEL)) {
            PIFSPLockFunctions.trace(TRACE_MASK, "-> PIFSPLockFunctions.getPHYPHmcInfo");
        }
        String string = "";
        try {
            this.cmdHelper = this.cecMgr.getCmdHelper();
            FspHmcInfoData fspHmcInfoData = new FspHmcInfoData();
            fspHmcInfoData = this.cmdHelper.getHmcInfo(unsignedInt16);
            string = fspHmcInfoData.getHmcInfo();
        }
        catch (PIHscServerException pIHscServerException) {
            if (PIFSPLockFunctions.tracing()) {
                PIFSPLockFunctions.trace(TRACE_MASK, "-> PIFSPLockFunctions.getPHYPHmcInfo: *ERROR*");
                pIHscServerException.printStackTrace();
            }
            if (!pIHscServerException.alreadyLogged()) {
                HSCLogUtils.serverLog(pIHscServerException, HSCLogUtils._CECClassLogInfo);
                pIHscServerException.setAlreadyLogged(true);
            }
            throw pIHscServerException;
        }
        if (PIFSPLockFunctions.tracing(Trace.LEVEL)) {
            PIFSPLockFunctions.trace(TRACE_MASK, "<- PIFSPLockFunctions.getPHYPHmcInfo");
        }
        return string;
    }

    public CIMValue getAllPHYPHmcInfo(Vector vector) throws PIHscServerException {
        int n = 0;
        FSPCmdMgr fSPCmdMgr = this.cecMgr.getCmdMgr();
        UnsignedInt16[] unsignedInt16Array = FspHmcInfoData.getNumOfHMCInfoSlots(fSPCmdMgr);
        System.out.println("Get rtn: " + unsignedInt16Array[0] + ": " + unsignedInt16Array[1]);
        if (unsignedInt16Array[0] != null) {
            n = unsignedInt16Array[0].intValue();
        }
        if (n > 0) {
            Vector<UnsignedInt8> vector2 = new Vector<UnsignedInt8>();
            Vector<String> vector3 = new Vector<String>();
            for (int i = 0; i < n; ++i) {
                String string = this.getPHYPHmcInfo(new UnsignedInt16(i));
                if (string.length() <= 0) continue;
                vector2.add(new UnsignedInt8((short)i));
                vector3.add(string);
            }
            if (vector2.size() > 0) {
                if (GlobalConfig.callMethodsWithValues) {
                    vector.add(new CIMValue(vector2, new CIMDataType(21)));
                    vector.add(new CIMValue(vector3, new CIMDataType(29)));
                } else {
                    vector.add(new CIMProperty("slots", new CIMValue(vector2, new CIMDataType(21))));
                    vector.add(new CIMProperty("HmcInfo", new CIMValue(vector3, new CIMDataType(29))));
                }
            }
        }
        return new CIMValue((Object)new UnsignedInt8(0));
    }

    public CIMValue getPHYPHmcInfo(Vector vector) throws PIHscServerException {
        Object object;
        UnsignedInt16 unsignedInt16 = null;
        try {
            object = (CIMProperty)vector.elementAt(0);
            unsignedInt16 = (UnsignedInt16)object.getValue().getValue();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        if (unsignedInt16 == null) {
            unsignedInt16 = new UnsignedInt16(65535);
        }
        object = " ";
        if (this.cecMgr.isHypervisorRunning()) {
            FspHmcInfoData fspHmcInfoData = this.cecMgr.getCmdHelper().getHmcInfo(unsignedInt16);
            object = fspHmcInfoData.getHmcInfo();
        } else {
            System.out.println("GetOnePHYPHmcInfo: phyp not available");
        }
        if (((String)object).trim().equals("") && unsignedInt16.intValue() == 65535) {
            System.out.println("GetOnePHYPHmcInfo: return cached hmc info for current HMC slot");
            try {
                object = new OmCecHscInfoUpdater(this.cecMgr).constructHscInfo();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        System.out.println("GetOnePHYPHmcInfo: hmcInfoStr=" + (String)object);
        return new CIMValue(object);
    }

    public ProviderCIMOMHandle getCimomHandle() {
        return this.cimomHandle;
    }

    public void setCimomHandle(ProviderCIMOMHandle providerCIMOMHandle) {
        this.cimomHandle = providerCIMOMHandle;
    }

    private static void trace(String string, String string2) {
        Trace.trace(string, string2);
    }

    private static boolean tracing() {
        return 3 <= Trace.LEVEL;
    }

    private static boolean tracing(int n) {
        return n <= Trace.LEVEL;
    }
}

